/*
    plmtty - interactive insteon PLM communications program
    Copyright (2012) University of Massachusetts Amherst
    Contact Sean Barker (sbarker@cs.umass.edu)
    Copyright (C) 2008  Matthew Randolph

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "plm.h"

char *options = "d:hv";

int main(int argc, char **argv) {
	int c, ttyfd, nfds;
  char* ttydevice = TTYDEVICE;
	fd_set readfds;
	int helpwanted = FALSE;
  int verbose = FALSE;

	char buff[128];

	while (0 < (c = getopt(argc, argv, options))) {
    switch (c) {
      case 'd':
        ttydevice = optarg;
        break;
      case 'h':
        helpwanted = TRUE;
        break;
      case 'v':
        verbose = TRUE;
        break;
    }
	}

	if (helpwanted) {
		fprintf(stdout,
"USAGE: %s [OPTION]...\n"
"\n"
"\tOPTIONS:\n"
"\n"
"\t-h\t\tdisplay this help menu\n"
"\t-d\t\tPLM tty device name (/dev/ttyUSB0)\n"
"\t-v\t\tverbose and debug output\n"
"\n",argv[0]);
		exit(0);
	}

  ttyfd = ttysetup(ttydevice, &readfds);
  nfds = 0;
  nfds = (STDIN > nfds) ? STDIN : nfds;
  nfds = (ttyfd > nfds) ? ttyfd : nfds;
  nfds++;

  while (1) {
    FD_SET(STDIN, &readfds);
    FD_SET(ttyfd, &readfds);
    pselect(nfds, &readfds, NULL, NULL, NULL, NULL);
    if (FD_ISSET(ttyfd, &readfds)) {
      readpacket(ttyfd, nfds, &readfds, NULL, verbose ? PRINT_DEBUG : PRINT_STD);
    } else if (FD_ISSET(STDIN, &readfds)) {
      fgets(buff, 127, stdin);
      // todo: check that the command is an acceptable length
      writepacket(ttyfd, buff);
    }
  }
}

