/*
    plmsend - send data to the insteon PLM and display a reply or timeout
    Copyright (2012) University of Massachusetts Amherst
    Contact Sean Barker (sbarker@cs.umass.edu)
    Copyright (C) 2008  Matthew Randolph
    Please see the file COPYING for license information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "plm.h"

char *options = "p:d:e:t:vhf";

int main(int argc, char **argv) {
	int c, ttyfd, nfds;
  char* ttydevice = TTYDEVICE;
	fd_set readfds;
	int helpwanted = FALSE;

	char *str = NULL, *cp, buff[32];
	int msec = 1000;
	int verbose = FALSE;
	int strset = FALSE;
	int plmcatpid = -1;
  int packets = 2;
	FILE *popenfile;
	struct timespec sleeptime;

	// Parse command line using getopt() from libc
	while (0 < (c = getopt(argc,argv,options))) {
		switch (c) {
      case 'p':
        packets = atoi(optarg);
        break;
      case 'd':
        ttydevice = optarg;
        break;
      case 'e':
        str = optarg;
        strset = TRUE;
        break;
      case 't':
        msec = atoi(optarg);
        break;
      case 'v':
        verbose = TRUE;
        break;
      case 'h':
        helpwanted = TRUE;
        break;
    }
	}

	if (helpwanted || argc == 1) {
		fprintf(stdout,
"USAGE: %s [OPTION]... hexstring\n"
"\n"
"\tOPTIONS:\n"
"\n"
"\t-h\t\tdisplay this help menu\n"
"\t-d\t\tPLM tty device name (/dev/ttyUSB0)\n"
"\t-t\t\tmax time to wait for a response in millisecs (1000)\n"
"\t-v\t\tverbose and debug output\n"
"\t-e\t\tspecify data to send as a hex string\n"
"\t-p\t\tspecify number of response packets (incl. ack) to read (2)\n"
"\n"
"Hex strings are case insensitive, but must not begin with 0x or 0X.\n"
"Only the last hex string specified will be used.\n",
argv[0]);
		exit(0);
	}

	if (!strset) {
		str = (char*) (argv[argc - 1]);
  }

	for (cp = str; *cp; cp++) {
		if (!ishex(*cp)) {
			fprintf(stderr,"%s: ERROR: Invalid command string\n", argv[0]);
			exit(1);
		}
  }

	if (0 != strncmp(str, "02", 2)) {
		fprintf(stderr,"%s: ERROR: Invalid command string\n", argv[0]);
		exit(1);
	}

	popenfile = popen("pidof -s plmcat", "r");
	fgets(buff, 6, popenfile);
	if (0 != strcmp(buff, "")) {
		plmcatpid = atoi(buff);
  }
	pclose(popenfile);

	if (plmcatpid > 0 && packets) {
		kill(plmcatpid, SIGSTOP);
  }

	sleeptime.tv_sec = ((msec - (msec % 1000)) / 1000);
	sleeptime.tv_nsec = (msec % 1000) * 1000000;

  ttyfd = ttysetup(ttydevice, &readfds);
  nfds = (ttyfd ? ttyfd : 0) + 1;

	// look for other commands here that will not get an ACK
  /*
	if (0 == strncmp(str,"0260",4)) {
		toplm = TRUE;
  }
  */

  writepacket(ttyfd, str);
  if (packets) {
    int i;
    FD_SET(ttyfd, &readfds);
    // read ACK but only print if verbose mode is set
    readpacket(ttyfd, nfds, &readfds, &sleeptime, verbose);
    for (i = 1; i < packets; i++) {
      if (!readpacket(ttyfd, nfds, &readfds, &sleeptime, verbose ? PRINT_DEBUG : PRINT_STD)) {
        break;
      }
    }
    if (plmcatpid > 0) {
      kill(plmcatpid, SIGCONT);
    }
  }

  close(ttyfd);
	return 0;
}

